<?php
require_once __DIR__ . '/../includes/functions.php';

// Se já estiver autenticado, redirecionar para o dashboard
if (isAdminAuthenticated()) {
    header('Location: index.php');
    exit;
}

$error_message = '';

// Processar login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $password = $_POST['password'];
    
    if (authenticateAdmin($password)) {
        header('Location: index.php');
        exit;
    } else {
        $error_message = 'Senha incorreta. Tente novamente.';
    }
}

$page_title = 'Login';
include __DIR__ . '/../includes/header.php';
?>

<div class="container">
    <div class="row justify-content-center align-items-center min-vh-100">
        <div class="col-md-6 col-lg-4">
            <div class="card">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <div class="mb-3">
                            <i class="bi bi-whatsapp" style="font-size: 3rem; color: var(--primary-color);"></i>
                        </div>
                        <h2 class="card-title">WhatsApp Rotator</h2>
                        <p class="text-muted">Acesso Administrativo</p>
                    </div>
                    
                    <?php if (!empty($error_message)): ?>
                        <div class="alert alert-danger" role="alert">
                            <i class="bi bi-exclamation-triangle"></i> <?php echo htmlspecialchars($error_message); ?>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="mb-4">
                            <label for="password" class="form-label">Senha de Administrador</label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="bi bi-lock"></i>
                                </span>
                                <input type="password" class="form-control" id="password" name="password" required autofocus>
                                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                    <i class="bi bi-eye" id="toggleIcon"></i>
                                </button>
                            </div>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-whatsapp btn-lg">
                                <i class="bi bi-box-arrow-in-right"></i> Entrar
                            </button>
                        </div>
                    </form>
                    
                    <div class="text-center mt-4">
                        <small class="text-muted">
                            Sistema de Rotação de WhatsApp<br>
                            Versão 1.0
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Toggle password visibility
    document.getElementById('togglePassword').addEventListener('click', function() {
        const passwordField = document.getElementById('password');
        const toggleIcon = document.getElementById('toggleIcon');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            toggleIcon.className = 'bi bi-eye-slash';
        } else {
            passwordField.type = 'password';
            toggleIcon.className = 'bi bi-eye';
        }
    });
    
    // Auto-focus no campo de senha
    document.getElementById('password').focus();
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>

