<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);
require_once __DIR__ . 
'/../includes/functions.php';

// Verificar autenticação
if (!isAdminAuthenticated()) {
    header('Location: login.php');
    exit;
}

// Parâmetros de filtro
$periodo = isset($_GET['periodo']) ? (int)$_GET['periodo'] : 30;
$grupo_id = isset($_GET['grupo_id']) ? (int)$_GET['grupo_id'] : 0;

$page_title = 'Relatórios';
include __DIR__ . '/../includes/header.php';

$pdo = getConnection();

// Estatísticas gerais do período
$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM cliques WHERE data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)");
$stmt->execute();
$total_cliques_periodo = $stmt->fetch()['total'];

// Cliques únicos por IP
$stmt = $pdo->prepare("SELECT COUNT(DISTINCT ip_address) as total FROM cliques WHERE data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)");
$stmt->execute();
$ips_unicos = $stmt->fetch()['total'];

// Grupo mais clicado
$stmt = $pdo->prepare("
    SELECT g.nome, COUNT(c.id) as cliques 
    FROM grupos g 
    LEFT JOIN cliques c ON g.id = c.grupo_id AND c.data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)
    WHERE g.ativo = 1 
    GROUP BY g.id 
    ORDER BY cliques DESC 
    LIMIT 1
");
$stmt->execute();
$grupo_mais_clicado = $stmt->fetch();

// Média de cliques por dia
$media_cliques_dia = $periodo > 0 ? round($total_cliques_periodo / $periodo, 1) : 0;

// Relatório por grupos
$sql_grupos = "
    SELECT g.id, g.nome, COUNT(c.id) as total_cliques,
           COUNT(DISTINCT c.ip_address) as ips_unicos,
           COUNT(DISTINCT DATE(c.data_clique)) as dias_com_cliques
    FROM grupos g 
    LEFT JOIN cliques c ON g.id = c.grupo_id AND c.data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)
    WHERE g.ativo = 1
";

if ($grupo_id > 0) {
    $sql_grupos .= " AND g.id = {$grupo_id}";
}

$sql_grupos .= " GROUP BY g.id ORDER BY total_cliques DESC";

$stmt = $pdo->query($sql_grupos);
$relatorio_grupos = $stmt->fetchAll();

// Relatório por números (se grupo específico selecionado)
$relatorio_numeros = [];
if ($grupo_id > 0) {
    $stmt = $pdo->prepare("
        SELECT n.id, n.nome, n.numero, COUNT(c.id) as total_cliques,
               COUNT(DISTINCT c.ip_address) as ips_unicos,
               MAX(c.data_clique) as ultimo_clique
        FROM numeros n 
        LEFT JOIN cliques c ON n.id = c.numero_id AND c.data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)
        WHERE n.grupo_id = ? AND n.ativo = 1
        GROUP BY n.id 
        ORDER BY total_cliques DESC
    ");
    $stmt->execute([$grupo_id]);
    $relatorio_numeros = $stmt->fetchAll();
}

// Cliques por dia para gráfico
$stmt = $pdo->prepare("
    SELECT DATE(data_clique) as data, COUNT(*) as cliques 
    FROM cliques 
    WHERE data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)
    GROUP BY DATE(data_clique) 
    ORDER BY data
");
$stmt->execute();
$cliques_por_dia = $stmt->fetchAll();

// Cliques por hora do dia
$stmt = $pdo->prepare("
    SELECT HOUR(data_clique) as hora, COUNT(*) as cliques 
    FROM cliques 
    WHERE data_clique >= DATE_SUB(NOW(), INTERVAL {$periodo} DAY)
    GROUP BY hora 
    ORDER BY hora
");
$stmt->execute();
$cliques_por_hora = $stmt->fetchAll();

// Obter lista de grupos para filtro
$grupos = getGroups(true);
?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar">
            <div class="text-center mb-4">
                <h4 class="text-white">
                    <i class="bi bi-whatsapp"></i> WhatsApp Rotator
                </h4>
            </div>
            
            <nav class="nav flex-column">
                <a class="nav-link" href="index.php">
                    <i class="bi bi-speedometer2"></i> Dashboard
                </a>
                <a class="nav-link" href="grupos.php">
                    <i class="bi bi-collection"></i> Grupos
                </a>
                <a class="nav-link" href="numeros.php">
                    <i class="bi bi-telephone"></i> Números
                </a>
                <a class="nav-link active" href="relatorios.php">
                    <i class="bi bi-bar-chart"></i> Relatórios
                </a>
                <hr class="text-white">
                <a class="nav-link" href="?logout=1">
                    <i class="bi bi-box-arrow-right"></i> Sair
                </a>
            </nav>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Relatórios</h1>
                <div class="d-flex gap-2">
                    <button class="btn btn-outline-primary" onclick="exportData()">
                        <i class="bi bi-download"></i> Exportar
                    </button>
                    <button class="btn btn-outline-secondary" onclick="window.print()">
                        <i class="bi bi-printer"></i> Imprimir
                    </button>
                </div>
            </div>
            
            <!-- Filtros -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" class="row g-3">
                        <div class="col-md-4">
                            <label for="periodo" class="form-label">Período</label>
                            <select class="form-select" id="periodo" name="periodo">
                                <option value="7" <?php echo $periodo == 7 ? 'selected' : ''; ?>>Últimos 7 dias</option>
                                <option value="30" <?php echo $periodo == 30 ? 'selected' : ''; ?>>Últimos 30 dias</option>
                                <option value="90" <?php echo $periodo == 90 ? 'selected' : ''; ?>>Últimos 90 dias</option>
                                <option value="365" <?php echo $periodo == 365 ? 'selected' : ''; ?>>Último ano</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="grupo_id" class="form-label">Grupo</label>
                            <select class="form-select" id="grupo_id" name="grupo_id">
                                <option value="0">Todos os grupos</option>
                                <?php foreach ($grupos as $grupo): ?>
                                    <option value="<?php echo $grupo['id']; ?>" <?php echo $grupo_id == $grupo['id'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($grupo['nome']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-whatsapp">
                                    <i class="bi bi-funnel"></i> Filtrar
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Estatísticas Resumo -->
            <div class="row mb-4">
                <div class="col-md-3 mb-3">
                    <div class="stats-card">
                        <div class="stats-number"><?php echo $total_cliques_periodo; ?></div>
                        <div>Total de Cliques</div>
                        <small>Últimos <?php echo $periodo; ?> dias</small>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                        <div class="stats-number"><?php echo $ips_unicos; ?></div>
                        <div>Visitantes Únicos</div>
                        <small>IPs diferentes</small>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                        <div class="stats-number"><?php echo $media_cliques_dia; ?></div>
                        <div>Média por Dia</div>
                        <small>Cliques diários</small>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="stats-card" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                        <div class="stats-number"><?php echo count($relatorio_grupos); ?></div>
                        <div>Grupos Ativos</div>
                        <small>Com cliques</small>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <!-- Gráfico de Cliques por Dia -->
                <?php if (!empty($cliques_por_dia)): ?>
                <div class="col-md-8 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="bi bi-graph-up"></i> Cliques por Dia
                            </h5>
                        </div>
                        <div class="card-body">
                            <canvas id="dailyClicksChart" width="400" height="200"></canvas>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Gráfico de Cliques por Hora -->
                <?php if (!empty($cliques_por_hora)): ?>
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="bi bi-clock"></i> Cliques por Hora
                            </h5>
                        </div>
                        <div class="card-body">
                            <canvas id="hourlyClicksChart" width="300" height="200"></canvas>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Relatório por Grupos -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-collection"></i> Relatório por Grupos
                    </h5>
                </div>
                <div class="card-body">
                    <?php if (empty($relatorio_grupos)): ?>
                        <p class="text-muted">Nenhum dado encontrado para o período selecionado.</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Grupo</th>
                                        <th>Total de Cliques</th>
                                        <th>IPs Únicos</th>
                                        <th>Dias com Cliques</th>
                                        <th>Taxa de Conversão</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($relatorio_grupos as $grupo): ?>
                                        <?php
                                        $taxa_conversao = $ips_unicos > 0 ? round(($grupo['ips_unicos'] / $ips_unicos) * 100, 1) : 0;
                                        ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo htmlspecialchars($grupo['nome']); ?></strong>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary"><?php echo $grupo['total_cliques']; ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-info"><?php echo $grupo['ips_unicos']; ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-success"><?php echo $grupo['dias_com_cliques']; ?></span>
                                            </td>
                                            <td>
                                                <?php echo $taxa_conversao; ?>%
                                            </td>
                                            <td>
                                                <a href="?periodo=<?php echo $periodo; ?>&grupo_id=<?php echo $grupo['id']; ?>" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-zoom-in"></i> Detalhes
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Relatório por Números (se grupo específico) -->
            <?php if ($grupo_id > 0 && !empty($relatorio_numeros)): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-telephone"></i> Relatório por Números
                        <?php
                        $grupo_atual = getGroup($grupo_id);
                        if ($grupo_atual) {
                            echo ' - ' . htmlspecialchars($grupo_atual['nome']);
                        }
                        ?>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Nome</th>
                                    <th>Número</th>
                                    <th>Total de Cliques</th>
                                    <th>IPs Únicos</th>
                                    <th>Último Clique</th>
                                    <th>% do Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $total_cliques_grupo = array_sum(array_column($relatorio_numeros, 'total_cliques'));
                                foreach ($relatorio_numeros as $numero): 
                                ?>
                                    <?php
                                    $percentual = $total_cliques_grupo > 0 ? round(($numero['total_cliques'] / $total_cliques_grupo) * 100, 1) : 0;
                                    ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo htmlspecialchars($numero['nome']); ?></strong>
                                        </td>
                                        <td>
                                            <code><?php echo formatWhatsAppNumber($numero['numero']); ?></code>
                                        </td>
                                        <td>
                                            <span class="badge bg-primary"><?php echo $numero['total_cliques']; ?></span>
                                        </td>
                                        <td>
                                            <span class="badge bg-info"><?php echo $numero['ips_unicos']; ?></span>
                                        </td>
                                        <td>
                                            <?php if ($numero['ultimo_clique']): ?>
                                                <small class="text-muted">
                                                    <?php echo date('d/m/Y H:i', strtotime($numero['ultimo_clique'])); ?>
                                                </small>
                                            <?php else: ?>
                                                <small class="text-muted">Nunca</small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar" role="progressbar" style="width: <?php echo $percentual; ?>%">
                                                    <?php echo $percentual; ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if (!empty($cliques_por_dia) || !empty($cliques_por_hora)): ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Gráfico de cliques por dia
    <?php if (!empty($cliques_por_dia)): ?>
    const dailyCtx = document.getElementById('dailyClicksChart').getContext('2d');
    const dailyChart = new Chart(dailyCtx, {
        type: 'line',
        data: {
            labels: [<?php echo implode(',', array_map(function($item) { return '"' . date('d/m', strtotime($item['data'])) . '"'; }, $cliques_por_dia)); ?>],
            datasets: [{
                label: 'Cliques',
                data: [<?php echo implode(',', array_column($cliques_por_dia, 'cliques')); ?>],
                borderColor: '#25d366',
                backgroundColor: 'rgba(37, 211, 102, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });
    <?php endif; ?>
    
    // Gráfico de cliques por hora
    <?php if (!empty($cliques_por_hora)): ?>
    const hourlyCtx = document.getElementById('hourlyClicksChart').getContext('2d');
    const hourlyChart = new Chart(hourlyCtx, {
        type: 'bar',
        data: {
            labels: [<?php echo implode(',', array_map(function($item) { return '"' . sprintf('%02d:00', $item['hora']) . '"'; }, $cliques_por_hora)); ?>],
            datasets: [{
                label: 'Cliques',
                data: [<?php echo implode(',', array_column($cliques_por_hora, 'cliques')); ?>],
                backgroundColor: 'rgba(37, 211, 102, 0.8)',
                borderColor: '#25d366',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });
    <?php endif; ?>
    
    function exportData() {
        // Implementar exportação de dados
        showAlert('Funcionalidade de exportação será implementada em breve!', 'info');
    }
</script>
<?php endif; ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>

