<?php
require_once __DIR__ . '/../includes/functions.php';

// Verificar se o parâmetro do grupo foi fornecido
if (!isset($_GET['g']) || empty($_GET['g'])) {
    http_response_code(400);
    die('Parâmetro de grupo não fornecido');
}

$group_hash = sanitize($_GET['g']);

// Buscar grupo pelo hash
$grupo = getGroupByHash($group_hash);
if (!$grupo) {
    http_response_code(404);
    die('Grupo não encontrado');
}

// Verificar se o grupo está ativo
if (!$grupo['ativo']) {
    http_response_code(404);
    die('Grupo não está ativo');
}

// Obter próximo número na rotação
$numero = getNextNumber($grupo['id']);
if (!$numero) {
    http_response_code(404);
    die('Nenhum número ativo encontrado neste grupo');
}

// Registrar o clique
$ip_address = getClientIP();
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
registerClick($grupo['id'], $numero['id'], $ip_address, $user_agent);

// Gerar URL do WhatsApp
$mensagem_padrao = isset($_GET['msg']) ? $_GET['msg'] : '';
$whatsapp_url = generateWhatsAppURL($numero['numero'], $mensagem_padrao);

if (!$whatsapp_url) {
    http_response_code(500);
    die('Erro ao gerar URL do WhatsApp');
}

// Redirecionar para o WhatsApp
header('Location: ' . $whatsapp_url);
exit;
?>
