<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);

require_once __DIR__ . 
'/../includes/functions.php';

$page_title = 'Redefinir Senha';
include __DIR__ . '/../includes/header.php';

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username_or_email = sanitize($_POST['username_or_email']);

    if (empty($username_or_email)) {
        $message = 'Por favor, insira seu nome de usuário ou e-mail.';
        $message_type = 'danger';
    } else {
        $pdo = getConnection();
        $stmt = $pdo->prepare("SELECT id, username, email FROM admins WHERE username = ? OR email = ?");
        $stmt->execute([$username_or_email, $username_or_email]);
        $admin = $stmt->fetch();

        if ($admin) {
            // Gerar token de redefinição de senha
            $token = bin2hex(random_bytes(32));
            $expires = date('Y-m-d H:i:s', strtotime('+1 hour')); // Token            // Armazenar token no banco de dados
            $stmt = $pdo->prepare("INSERT INTO password_resets (admin_id, token, expires_at) VALUES (?, ?, ?)");
            if ($stmt->execute([$admin["id"], $token, $expires])) {
                // Em um sistema real, você enviaria este link por e-mail para o usuário.
                // Para fins de demonstração, vamos exibir uma mensagem genérica.
                $message = 'Se um usuário com este nome de usuário ou e-mail for encontrado, um link para redefinir sua senha será enviado para o e-mail associado.';
                $message_type = 'success';
            } else {
                $message = 'Erro ao gerar token de redefinição de senha.';
                $message_type = 'danger';
            }
        } else {
            $message = 'Nome de usuário ou e-mail não encontrado.';
            $message_type = 'danger';
        }
    }
}

?>

<div class="container">
    <div class="row justify-content-center align-items-center min-vh-100">
        <div class="col-md-6 col-lg-4">
            <div class="card">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <div class="mb-3">
                            <i class="bi bi-key" style="font-size: 3rem; color: var(--primary-color);"></i>
                        </div>
                        <h2 class="card-title">Redefinir Senha</h2>
                        <p class="text-muted">Insira seu nome de usuário ou e-mail para redefinir sua senha.</p>
                    </div>
                    
                    <?php if (!empty($message)): ?>
                        <div class="alert alert-<?php echo $message_type; ?>" role="alert">
                            <?php echo $message; ?>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="mb-4">
                            <label for="username_or_email" class="form-label">Nome de Usuário ou E-mail</label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="bi bi-person"></i>
                                </span>
                                <input type="text" class="form-control" id="username_or_email" name="username_or_email" required autofocus>
                            </div>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-whatsapp btn-lg">
                                <i class="bi bi-arrow-right-circle"></i> Enviar Link de Redefinição
                            </button>
                        </div>
                    </form>
                    
                    <div class="text-center mt-4">
                        <a href="login.php">Voltar para o Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
