<?php
ini_set('log_errors', 1); // Ativa o log de erros
ini_set('error_log', __DIR__ . '/meu_arquivo_de_log.log'); // Caminho do log
error_reporting(E_ALL);
ini_set('display_errors', 0); // Opcional: oculta na tela, mas registra no arquivo
require_once __DIR__ . '/../includes/functions.php';

// Verificar se está autenticado
if (!isAdminAuthenticated()) {
    header('Location: login.php');
    exit;
}

// Processar logout
if (isset($_GET['logout'])) {
    logoutAdmin();
    header('Location: login.php');
    exit;
}

// Obter estatísticas básicas
try {
    $pdo = getConnection();
    
    // Total de grupos
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM grupos WHERE ativo = 1");
    $total_grupos = $stmt->fetch()['total'];
    
    // Total de números
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM numeros WHERE ativo = 1");
    $total_numeros = $stmt->fetch()['total'];
    
    // Cliques hoje
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM cliques WHERE DATE(data_clique) = CURDATE()");
    $cliques_hoje = $stmt->fetch()['total'];
    
    // Cliques este mês
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM cliques WHERE MONTH(data_clique) = MONTH(CURDATE()) AND YEAR(data_clique) = YEAR(CURDATE())");
    $cliques_mes = $stmt->fetch()['total'];
    
} catch (Exception $e) {
    error_log("Erro ao obter estatísticas: " . $e->getMessage());
    $total_grupos = 0;
    $total_numeros = 0;
    $cliques_hoje = 0;
    $cliques_mes = 0;
}

$page_title = 'Dashboard';
include __DIR__ . '/../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
            <div class="position-sticky pt-3">
                <div class="text-center mb-4">
                    <i class="bi bi-whatsapp" style="font-size: 2rem; color: var(--primary-color);"></i>
                    <h5 class="mt-2">WhatsApp Rotator</h5>
                </div>
                
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="grupos.php">
                            <i class="bi bi-collection"></i> Grupos
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="numeros.php">
                            <i class="bi bi-telephone"></i> Números
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="relatorios.php">
                            <i class="bi bi-graph-up"></i> Relatórios
                        </a>
                    </li>
                    <li class="nav-item mt-3">
                        <a class="nav-link text-danger" href="?logout=1">
                            <i class="bi bi-box-arrow-right"></i> Sair
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <a href="grupos.php" class="btn btn-sm btn-outline-secondary">
                            <i class="bi bi-plus"></i> Novo Grupo
                        </a>
                    </div>
                </div>
            </div>

            <!-- Cards de estatísticas -->
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Grupos Ativos
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_grupos; ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-collection fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Números Ativos
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_numeros; ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-telephone fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                        Cliques Hoje
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $cliques_hoje; ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-cursor fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                        Cliques Este Mês
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $cliques_mes; ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-graph-up fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Instruções de uso -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Como usar o sistema</h6>
                        </div>
                        <div class="card-body">
                            <ol>
                                <li><strong>Criar Grupos:</strong> Acesse "Grupos" e crie grupos para organizar seus números de WhatsApp.</li>
                                <li><strong>Adicionar Números:</strong> Em "Números", adicione os números de WhatsApp que farão parte da rotação.</li>
                                <li><strong>Gerar Links:</strong> Use os links gerados para cada grupo. O sistema rotacionará automaticamente entre os números.</li>
                                <li><strong>Acompanhar:</strong> Monitore os cliques e estatísticas em "Relatórios".</li>
                            </ol>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Ações Rápidas</h6>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="grupos.php" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Criar Novo Grupo
                                </a>
                                <a href="numeros.php" class="btn btn-success">
                                    <i class="bi bi-telephone-plus"></i> Adicionar Número
                                </a>
                                <a href="relatorios.php" class="btn btn-info">
                                    <i class="bi bi-graph-up"></i> Ver Relatórios
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

