<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);

require_once __DIR__ . 
'/../includes/functions.php';

$page_title = 'Cadastro de Usuário';
include __DIR__ . '/../includes/header.php';

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($username) || empty($password) || empty($confirm_password)) {
        $message = 'Todos os campos são obrigatórios.';
        $message_type = 'danger';
    } elseif ($password !== $confirm_password) {
        $message = 'As senhas não coincidem.';
        $message_type = 'danger';
    } elseif (strlen($password) < 6) {
        $message = 'A senha deve ter pelo menos 6 caracteres.';
        $message_type = 'danger';
    } else {
        // Verificar se o usuário já existe
        $pdo = getConnection();
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM admins WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetchColumn() > 0) {
            $message = 'Nome de usuário já existe. Por favor, escolha outro.';
            $message_type = 'danger';
        } else {
            // Hash da senha
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Inserir novo usuário no banco de dados
            $stmt = $pdo->prepare("INSERT INTO admins (username, password) VALUES (?, ?)");
            if ($stmt->execute([$username, $hashed_password])) {
                $message = 'Usuário cadastrado com sucesso!';
                $message_type = 'success';
            } else {
                $message = 'Erro ao cadastrar usuário.';
                $message_type = 'danger';
            }
        }
    }
}

?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 col-lg-2 sidebar">
            <div class="text-center mb-4">
                <h4 class="text-white">
                    <i class="bi bi-whatsapp"></i> WhatsApp Rotator
                </h4>
            </div>
            
            <nav class="nav flex-column">
                <a class="nav-link" href="index.php">
                    <i class="bi bi-speedometer2"></i> Dashboard
                </a>
                <a class="nav-link" href="grupos.php">
                    <i class="bi bi-collection"></i> Grupos
                </a>
                <a class="nav-link" href="numeros.php">
                    <i class="bi bi-telephone"></i> Números
                </a>
                <a class="nav-link" href="relatorios.php">
                    <i class="bi bi-bar-chart"></i> Relatórios
                </a>
                <a class="nav-link active" href="register.php">
                    <i class="bi bi-person-plus"></i> Cadastrar Usuário
                </a>
                <hr class="text-white">
                <a class="nav-link" href="?logout=1">
                    <i class="bi bi-box-arrow-right"></i> Sair
                </a>
            </nav>
        </div>
        
        <!-- Main Content -->
        <div class="col-md-9 col-lg-10 main-content">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Cadastro de Usuário</h1>
            </div>
            
            <?php if ($message): ?>
                <div class="alert alert-<?php echo $message_type; ?>" role="alert">
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-3">
                            <label for="username" class="form-label">Nome de Usuário</label>
                            <input type="text" class="form-control" id="username" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Senha</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <div class="mb-3">
                            <label for="confirm_password" class="form-label">Confirmar Senha</label>
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                        </div>
                        <button type="submit" class="btn btn-whatsapp">Cadastrar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
