<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);

require_once __DIR__ . 
'/../includes/functions.php';

$page_title = 'Redefinir Senha';
include __DIR__ . '/../includes/header.php';

$message = '';
$message_type = '';

$token = $_GET['token'] ?? '';

if (empty($token)) {
    $message = 'Token de redefinição de senha inválido ou ausente.';
    $message_type = 'danger';
} else {
    $pdo = getConnection();
    $stmt = $pdo->prepare("SELECT * FROM password_resets WHERE token = ? AND expires_at > NOW()");
    $stmt->execute([$token]);
    $reset_request = $stmt->fetch();

    if (!$reset_request) {
        $message = 'Token de redefinição de senha inválido ou expirado.';
        $message_type = 'danger';
    } else {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $password = $_POST['password'];
            $confirm_password = $_POST['confirm_password'];

            if (empty($password) || empty($confirm_password)) {
                $message = 'Todos os campos são obrigatórios.';
                $message_type = 'danger';
            } elseif ($password !== $confirm_password) {
                $message = 'As senhas não coincidem.';
                $message_type = 'danger';
            } elseif (strlen($password) < 6) {
                $message = 'A senha deve ter pelo menos 6 caracteres.';
                $message_type = 'danger';
            } else {
                // Hash da nova senha
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);

                // Atualizar senha do usuário
                $stmt = $pdo->prepare("UPDATE admins SET password = ? WHERE id = ?");
                if ($stmt->execute([$hashed_password, $reset_request['admin_id']])) {
                    // Remover token de redefinição após o uso
                    $stmt = $pdo->prepare("DELETE FROM password_resets WHERE token = ?");
                    $stmt->execute([$token]);

                    $message = 'Sua senha foi redefinida com sucesso. Você já pode fazer login.';
                    $message_type = 'success';
                } else {
                    $message = 'Erro ao redefinir a senha.';
                    $message_type = 'danger';
                }
            }
        }
    }
}

?>

<div class="container">
    <div class="row justify-content-center align-items-center min-vh-100">
        <div class="col-md-6 col-lg-4">
            <div class="card">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <div class="mb-3">
                            <i class="bi bi-key-fill" style="font-size: 3rem; color: var(--primary-color);"></i>
                        </div>
                        <h2 class="card-title">Redefinir Senha</h2>
                        <p class="text-muted">Insira sua nova senha.</p>
                    </div>
                    
                    <?php if (!empty($message)): ?>
                        <div class="alert alert-<?php echo $message_type; ?>" role="alert">
                            <?php echo $message; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($message_type !== 'success' && $reset_request): // Mostrar formulário apenas se o token for válido e a senha ainda não foi redefinida ?>
                        <form method="POST">
                            <div class="mb-3">
                                <label for="password" class="form-label">Nova Senha</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="mb-4">
                                <label for="confirm_password" class="form-label">Confirmar Nova Senha</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-whatsapp btn-lg">
                                    <i class="bi bi-check-circle"></i> Redefinir Senha
                                </button>
                            </div>
                        </form>
                    <?php endif; ?>
                    
                    <div class="text-center mt-4">
                        <a href="login.php">Voltar para o Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
