<?php
ini_set('log_errors', 1); // Ativa o log de erros
ini_set('error_log', __DIR__ . '/meu_arquivo_de_log.log'); // Caminho do log
error_reporting(E_ALL);
ini_set('display_errors', 0); // Opcional: oculta na tela, mas registra no arquivo
require_once __DIR__ . '/includes/functions.php';

$page_title = 'WhatsApp Rotator';
include __DIR__ . '/includes/header.php';
?>

<div class="container">
    <div class="row justify-content-center align-items-center min-vh-100">
        <div class="col-md-8 col-lg-6">
            <div class="text-center mb-5">
                <div class="mb-4">
                    <i class="bi bi-whatsapp" style="font-size: 5rem; color: var(--primary-color);"></i>
                </div>
                <h1 class="display-4 fw-bold text-primary">WhatsApp Rotator</h1>
                <p class="lead text-muted">Sistema inteligente de rotação de contatos WhatsApp</p>
            </div>
            
            <div class="card">
                <div class="card-body p-5">
                    <h3 class="card-title text-center mb-4">Como funciona?</h3>
                    
                    <div class="row text-center">
                        <div class="col-md-4 mb-4">
                            <div class="mb-3">
                                <i class="bi bi-collection" style="font-size: 2.5rem; color: var(--primary-color);"></i>
                            </div>
                            <h5>1. Crie Grupos</h5>
                            <p class="text-muted">Organize seus números de WhatsApp em grupos temáticos</p>
                        </div>
                        
                        <div class="col-md-4 mb-4">
                            <div class="mb-3">
                                <i class="bi bi-telephone-plus" style="font-size: 2.5rem; color: var(--primary-color);"></i>
                            </div>
                            <h5>2. Adicione Números</h5>
                            <p class="text-muted">Cadastre os números de WhatsApp que farão parte da rotação</p>
                        </div>
                        
                        <div class="col-md-4 mb-4">
                            <div class="mb-3">
                                <i class="bi bi-link-45deg" style="font-size: 2.5rem; color: var(--primary-color);"></i>
                            </div>
                            <h5>3. Gere Links</h5>
                            <p class="text-muted">Cada grupo gera um link único que alterna entre os números automaticamente</p>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="admin/" class="btn btn-whatsapp btn-lg">
                            <i class="bi bi-gear"></i> Acessar Painel Administrativo
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="row mt-5">
                <div class="col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <i class="bi bi-bar-chart" style="font-size: 2rem; color: var(--primary-color);"></i>
                            <h5 class="mt-3">Relatórios Detalhados</h5>
                            <p class="text-muted">Acompanhe quantos cliques cada número e grupo recebeu</p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <i class="bi bi-shield-check" style="font-size: 2rem; color: var(--primary-color);"></i>
                            <h5 class="mt-3">Distribuição Inteligente</h5>
                            <p class="text-muted">Os contatos são distribuídos de forma equilibrada entre os números</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="text-center mt-4">
                <small class="text-muted">
                    Sistema de Rotação de WhatsApp - Versão 1.0<br>
                    Desenvolvido para otimizar o atendimento ao cliente
                </small>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

