<?php
// Configuração do banco de dados para cPanel
define("DB_HOST", "localhost");
define("DB_NAME", "eatr8609_whatsapp");
define("DB_USER", "eatr8609_whatsapp");
define("DB_PASS", "Go#KeZ;G%D[HYo.G");
define("DB_CHARSET", "utf8mb4");

// Configurações gerais
define("SITE_URL", "http://p2think.net.br/whatsapp");
// define("ADMIN_PASSWORD", "drcesar@1368"); // Removido: autenticação agora é baseada na tabela 'admins'

// Configurações de segurança
define("SECRET_KEY", "esantos_whatsapp_2025_chave_secreta_fixa");

// Função para conectar ao banco de dados - Otimizada para cPanel
function getConnection() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
            ];
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            // Log do erro para debug
            error_log("Erro de conexão MySQL: " . $e->getMessage());
            die('Erro de conexão com o banco de dados. Verifique as credenciais.');
        }
    }
    
    return $pdo;
}

// Função para verificar se as tabelas existem e criar se necessário
function initializeDatabase() {
    try {
        $pdo = getConnection();
        
        // Criar tabela grupos
        $pdo->exec("CREATE TABLE IF NOT EXISTS grupos (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nome VARCHAR(100) NOT NULL,
            descricao TEXT,
            ativo BOOLEAN DEFAULT 1,
            data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");

        // Criar tabela admins para usuários do painel
        $pdo->exec("CREATE TABLE IF NOT EXISTS admins (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) NOT NULL UNIQUE,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(100) UNIQUE,
            data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        
        // Criar tabela numeros
        $pdo->exec("CREATE TABLE IF NOT EXISTS numeros (
            id INT AUTO_INCREMENT PRIMARY KEY,
            numero VARCHAR(20) NOT NULL,
            nome VARCHAR(100),
            grupo_id INT,
            ativo BOOLEAN DEFAULT 1,
            data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (grupo_id) REFERENCES grupos(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        
        // Criar tabela cliques
        $pdo->exec("CREATE TABLE IF NOT EXISTS cliques (
            id INT AUTO_INCREMENT PRIMARY KEY,
            grupo_id INT,
            numero_id INT,
            ip_address VARCHAR(45),
            user_agent TEXT,
            data_clique DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (grupo_id) REFERENCES grupos(id) ON DELETE CASCADE,
            FOREIGN KEY (numero_id) REFERENCES numeros(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        
        // Criar tabela rotacao_estado
        $pdo->exec("CREATE TABLE IF NOT EXISTS rotacao_estado (
            grupo_id INT PRIMARY KEY,
            ultimo_numero_id INT,
            contador INT DEFAULT 0,
            FOREIGN KEY (grupo_id) REFERENCES grupos(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");

        // Criar tabela password_resets
        $pdo->exec("CREATE TABLE IF NOT EXISTS password_resets (
            id INT AUTO_INCREMENT PRIMARY KEY,
            admin_id INT NOT NULL,
            token VARCHAR(255) NOT NULL UNIQUE,
            expires_at DATETIME NOT NULL,
            FOREIGN KEY (admin_id) REFERENCES admins(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        
    } catch (PDOException $e) {
        error_log("Erro ao criar tabelas: " . $e->getMessage());
        die('Erro ao inicializar banco de dados: ' . $e->getMessage());
    }
}

// Inicializar banco de dados
initializeDatabase();
?>
