 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script>
        // Função para copiar texto para clipboard (com fallback para HTTP)
        function copyToClipboard(text) {
            // Método 1: Tentar usar a API moderna (funciona apenas em HTTPS)
            if (navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(text).then(function() {
                    showAlert('Link copiado para a área de transferência!', 'success');
                }, function(err) {
                    console.error('Erro ao copiar com clipboard API: ', err);
                    fallbackCopyToClipboard(text);
                });
            } else {
                // Método 2: Fallback para HTTP ou navegadores antigos
                fallbackCopyToClipboard(text);
            }
        }
        
        // Função de fallback para copiar texto (funciona em HTTP)
        function fallbackCopyToClipboard(text) {
            try {
                // Criar elemento temporário
                const textArea = document.createElement('textarea');
                textArea.value = text;
                textArea.style.position = 'fixed';
                textArea.style.left = '-999999px';
                textArea.style.top = '-999999px';
                document.body.appendChild(textArea);
                
                // Selecionar e copiar
                textArea.focus();
                textArea.select();
                
                const successful = document.execCommand('copy');
                document.body.removeChild(textArea);
                
                if (successful) {
                    showAlert('Link copiado para a área de transferência!', 'success');
                } else {
                    showAlert('Não foi possível copiar automaticamente. Selecione e copie manualmente (Ctrl+C).', 'warning');
                    selectText(text);
                }
            } catch (err) {
                console.error('Erro ao copiar: ', err);
                showAlert('Erro ao copiar. Tente selecionar e copiar manualmente (Ctrl+C).', 'danger');
                selectText(text);
            }
        }
        
        // Função para selecionar texto em um campo (como último recurso)
        function selectText(text) {
            // Encontrar o campo de input que contém o texto
            const inputs = document.querySelectorAll('input[readonly]');
            for (let input of inputs) {
                if (input.value === text) {
                    input.focus();
                    input.select();
                    break;
                }
            }
        }
        
        // Função para mostrar alertas
        function showAlert(message, type = 'info') {
            const alertHtml = `
                <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            `;
            
            // Adicionar alerta no topo da página
            const container = document.querySelector('.main-content') || document.body;
            container.insertAdjacentHTML('afterbegin', alertHtml);
            
            // Auto-remover após 5 segundos
            setTimeout(() => {
                const alert = container.querySelector('.alert');
                if (alert) {
                    alert.remove();
                }
            }, 5000);
        }
        
        // Função para validar número de WhatsApp
        function validateWhatsAppNumber(number) {
            const cleaned = number.replace(/[^0-9]/g, '');
            return cleaned.length >= 10 && cleaned.length <= 15;
        }
        
        // Função para formatar número de WhatsApp
        function formatWhatsAppNumber(number) {
            let cleaned = number.replace(/[^0-9]/g, '');
            
            // Se tem 11 dígitos e não começa com 55, adiciona código do país
            if (cleaned.length === 11 && !cleaned.startsWith('55')) {
                cleaned = '55' + cleaned;
            }
            
            // Formatar para exibição
            if (cleaned.length === 13 && cleaned.startsWith('55')) {
                return `+55 (${cleaned.substr(2, 2)}) ${cleaned.substr(4, 5)}-${cleaned.substr(9, 4)}`;
            }
            
            return '+' + cleaned;
        }
        
        // Função para confirmar exclusão
        function confirmDelete(message = 'Tem certeza que deseja excluir este item?') {
            return confirm(message);
        }
        
        // Inicialização quando o documento estiver pronto
        $(document).ready(function() {
            // Adicionar máscara para campos de telefone
            $('input[data-mask="phone"]').on('input', function() {
                let value = $(this).val().replace(/[^0-9]/g, '');
                if (value.length <= 11) {
                    value = value.replace(/(\d{2})(\d{5})(\d{4})/, '($1) $2-$3');
                } else {
                    value = value.replace(/(\d{2})(\d{2})(\d{5})(\d{4})/, '+$1 ($2) $3-$4');
                }
                $(this).val(value);
            });
            
            // Adicionar tooltips do Bootstrap
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</body>
</html>
